function Character(name)
{
	this.name = name;
	this.hp = 20;
	this.hpmax = 20;
	this.mp = 10;
	this.mpmax = 10;
	this.strength = 1;
	this.speed = 1;
	this.stamina = 1;
	this.magic = 1;
	this.exp = 0;
	this.lv = 1;
	this.reqExp = 20;
	this.specials = new Array();
	this.equipment = new Array(5);
	this.equipment[0] = items.blank;
	this.equipment[1] = items.blank;
	this.equipment[2] = items.blank;
	this.equipment[3] = items.blank;
	this.equipment[4] = items.blank;
	this.sprite = LoadSpriteset(name+".rss");
	this.aTime = 0; // Time animation was last switched
	this.aDirection = "Battle-normal";
	this.aOldDirection = "";
	this.aFrame = 0;
	this.aColor = colors.white;
	this.aFreeze = false;
	this.situation = "Normal";
	this.ailments = new Ailments();
	this.act = false;
	this.defending = false;
}

/*
	All character sprites must have following directions
	north
	south
	east
	west
	northeast
	southeast
	southwest
	northwest
	Battle-normal
	Battle-attack
	Battle-magic
	Battle-hurt
	Battle-weak
	Battle-wounded
*/

// Draws the character on the screen
Character.prototype.draw = function(x, y, direction, freeze)
{
	if (direction == "Normal")
	{
		if (this.hp > this.hpmax * .25)
		{
			this.aDirection = "Battle-normal";
		}
		else if (this.hp <= this.hpmax * .25 && this.hp > 0)
		{
			this.aDirection = "Battle-weak";
		}
		else if (this.hp == 0)
		{
			this.aDirection = "Battle-wounded";
		}
	}
	if (this.aOldDirection != this.aDirection)
	{
		this.aFrame = 0;
		this.aTime = GetTime();
		this.aOldDirection = this.aDirection;
		this.aFreeze = false;
	}
	if (x == undefined && y == undefined)
	{
		x = this.x;
		y = this.y;
	}
	this.sprite.images[this.sprite.directions[StrToDir(this.aDirection, this.sprite)].frames[this.aFrame].index].blitMask(x, y, this.aColor);
	if (freeze == undefined || freeze == false)
	{
		if (this.aTime + (this.sprite.directions[StrToDir(this.aDirection, this.sprite)].frames[this.aFrame].delay * 10) <= GetTime())
		{
			this.aTime = GetTime();
			this.aFrame ++;
			if (this.aFrame >= this.sprite.directions[StrToDir(this.aDirection, this.sprite)].frames.length)
			{
				this.aFrame = 0;
			}
		}
	}
}

Character.prototype.turn = function()
{
	this.defending = true;
	Game.battleMenu.reset();
	Game.battle.character = this;
	if (true) // Replace with stuff for status ailments
	{
		Game.battleMenu.execute(this);
		this.act = true;
	}
}

Character.prototype.getAttack = function()
{
	return this.strength + this.equipment[0].attack;
}

Character.prototype.getDefense = function()
{
	return this.stamina + this.equipment[1].defense + this.equipment[2].defense + this.equipment[3].defense;
}

Character.prototype.getMDefense = function()
{
	return this.magic + this.equipment[1].mdefense + this.equipment[2].mdefense + this.equipment[3].mdefense;
}

Character.prototype.getSpeed = function()
{
	return this.speed;
}

Character.prototype.attack = function(target)
{
	return this.getAttack() - target.getDefense();
}

Character.prototype.defend = function()
{
	this.defending = true;
}

Character.prototype.special = function(target, special)
{

}

Character.prototype.die = function()
{
}

var characters = new Object()
characters.damizean = new Character("Damizean");
characters.damizean.strength = 18;
characters.damizean.speed = 30;
characters.damizean.specials[0] = specials.jump;